#include <IRremote.h>
IRrecv irrecv(11);

#include "Keyboard.h"

void setup() {
  delay(1000);
  Serial.begin(115200); //Serial
  Keyboard.begin();     //keyboard
  irrecv.enableIRIn();  // Start the receiver
}

void loop() {
  decode_results  results;          //struct for results of IR receiver
  unsigned long code;  
  if (irrecv.decode(&results)) {    //decode
    code=results.value;
    irrecv.resume();                //get ready for next once we've saved code
    Serial.print("0x");
    Serial.println(code,HEX);    
    Keyboard.print("0x");
    Keyboard.print(code,HEX);
    Keyboard.write(KEY_RETURN);     //can't do println
  }  
}

